package gov.va.med.mhv.usermgmt.service.impl;

import java.sql.Timestamp;

import org.apache.commons.lang.StringUtils;
import org.tigris.atlas.service.VoidServiceResponse;

import gov.va.med.mhv.service.MHVAbstractService;
import gov.va.med.mhv.usermgmt.enumeration.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;
import gov.va.med.mhv.usermgmt.service.ServiceFactory;
import gov.va.med.mhv.usermgmt.service.UserProfileService;
import gov.va.med.mhv.usermgmt.service.UserProfileServiceResponse;
import gov.va.med.mhv.usermgmt.service.UserRegistrationService;
import gov.va.med.mhv.usermgmt.transfer.UserProfile;
import gov.va.med.mhv.usermgmt.util.Auditor;

/**
 * Service implementation class for the UserRegistration service
 */
public class UserRegistrationServiceImpl extends MHVAbstractService 
    implements UserRegistrationService 
{

	/**
	 * Execute the RegisterUser service. 
     * Composite service that creates a new user profile and 
     * user login credentials
	 *
	 * @return RegisterUserServiceResponse
	 */
	public UserProfileServiceResponse registerUser(
        UserProfile userProfile, String verifySsn, String userName, 
        String password, String confirmPassword,Timestamp termsUpdateTime) 
    {
		UserProfileServiceResponse response = new UserProfileServiceResponse();
		UserProfileService userProfileService = ServiceFactory.
            createUserProfileService();
		
		boolean fccxReg = false;
		
		// Save the user profile
		// JAZZ # 143252 - Federated Credential - took care of username being null
		if(userName != null) {
			userName = StringUtils.lowerCase(userName);
			userProfile.setUserName(userName);
		} else {
			fccxReg = true;
		}
		
		UserProfileServiceResponse userProfileResponse = userProfileService.
            saveUserProfile(userProfile, verifySsn);
		
		//JAZZ # 143252 - Federated Credential - Made sure that the username is changed to FirstName initial + LastName initial + _ + user profile id
//		if(fccxReg) {
//			userProfile.setUserName(userProfile.getFirstName().substring(0, 1) + userProfile.getLastName().substring(0, 1) + "_" + userProfile.getId());
//			userProfileResponse = 
//				gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
//		}
		
		UserProfile savedUserProfile = userProfileResponse.getUserProfile();
		
		response.setUserProfile(savedUserProfile);
		
		if (hasErrorMessages(userProfileResponse)) {
            copyMessages(response, userProfileResponse);
			return response;
		}
		
        boolean successful = false;
        try {
        	VoidServiceResponse voidResponse = null;
    		// JAZZ # 143252 - Federated Credential - took care of username being null
        	if(userName != null) {
	    		// Create the user credentials in the authentication provider
	    		VoidServiceResponse createUserResponse = ServiceFactory.
	                createUserService().createUser(userName, password, 
	                confirmPassword);
	    		if (hasErrorMessages(createUserResponse)) {
	                copyMessages(response, createUserResponse);
	                return response;
	    		} 
	    		// Save the password in the password history
	    		//VoidServiceResponse voidResponse = userProfileService.savePasswordHistory(userProfileService.getProfileForUser(userName).getUserProfile(), password, false);
	    		voidResponse = userProfileService.savePasswordHistory(savedUserProfile, password, false);
	    		
	            if (hasErrorMessages(voidResponse)) {
	    			copyMessages(response, voidResponse);
	                return response;
	            }
        	}
    		// Accept terms
    		Timestamp now = new Timestamp(System.currentTimeMillis());
    		voidResponse = userProfileService.acceptTerms(savedUserProfile,
                termsUpdateTime, now);
    		if (hasErrorMessages(voidResponse)) {
    			copyMessages(response, voidResponse);
                return response;
    		}
            
            voidResponse = Auditor.auditRegistrationEvent(savedUserProfile.
                getId(), ActivityActorTypeEnumeration.SELF);
            if (hasErrorMessages(voidResponse)) {
                copyMessages(response, voidResponse);
                return response;
            }
            
            //addInfo(response, UserManagementMessages.SUCCESSFUL_REGISTRATION, null);
            successful = true;
            if(!hasErrorMessages(response))
            	copyMessages(response, userProfileResponse);
            return response;
            
        } finally {
            
            if (!successful) {
                response.getUserProfile().setId(null);
            }
        }
	}

}